function bias = gaussian_bias_v2(Nt,L)

% GAUSSIAN_BIAS Computes bias of gaussian entropy estimates
%
% -----
% USAGE
% -----
%
%     bias = gaussian_bias(nt,L)
%
% where NT is the number of trials used for the estimation of entropy and L
% is the dimensionality of the response. NT can either be an integer scalar
% or a column arra of integers: in this case the bias is computed for each
% of the values in NT.
%
% See also ENTROPY, INFORMATION

%   Copyright (C) 2010 Cesare Magri
%   Version: 1.0.0

% -------
% LICENSE
% -------
% This software is distributed free under the condition that:
%
% 1. it shall not be incorporated in software that is subsequently sold;
%
% 2. the authorship of the software shall be acknowledged and the following
%    article shall be properly cited in any publication that uses results
%    generated by the software:
%
%      Magri C, Whittingstall K, Singh V, Logothetis NK, Panzeri S: A
%      toolbox for the fast information analysis of multiple-site LFP, EEG
%      and spike train recordings. BMC Neuroscience 2009 10(1):81;
%
% 3.  this notice shall remain in place in each source file.

% ----------
% DISCLAIMER
% ----------
% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
% IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
% THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
% PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
% CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
% EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
% PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
% LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
% NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
% SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

persistent Previous nPrevious previousInd;


if isempty(nPrevious)
    foundFlag = false;
    nPrevious = 0;
    previousInd = 0;
    
else
    k = 1;
    foundFlag = false;
    while (~foundFlag && k<=nPrevious)
        ind = mod(previousInd+k-1, nPrevious) + 1;
        if Previous(ind).L==L && all(size(Previous(ind).Nt)==size(Nt)) && all(Previous(ind).Nt==Nt)
            foundFlag = true;
        end
        
        k = k+1;
        
    end
end
    
if ~foundFlag
    % Copying in permanent variables
    previousInd = mod(previousInd, 10)+1;
    Previous(previousInd).Nt = Nt;
    Previous(previousInd).L  = L;
    
    if nPrevious<=10
        nPrevious = nPrevious + 1;
    end
    
    Nt = Nt-1;

    NtMat = Nt(:, ones(L,1));

    pvec = 0:L-1;

    NtMat = NtMat - pvec(ones(length(Nt),1), :);

    bias = sum(psi(NtMat./2), 2) - L.*log(Nt(:,1)./2);
    bias = bias ./ (2*log(2));
    
    Previous(previousInd).bias = bias;
    
else
    bias = Previous(ind).bias;
    previousInd = ind;
    
end